/*
 * Decompiled with CFR 0.152.
 */
package tw.com.prolific.driver.pl2303;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.util.Log;
import android.widget.Toast;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class PL2303Driver {
    private boolean mReadPakcetChecker = false;
    private static boolean bDebugMesg = false;
    private static boolean bDebugMesg_VendorCommand = false;
    private static boolean bDebugMesg_EEPROMCommand = false;
    private static String strLibVerionNumber = "2.0.9.22";
    public static final int BAUD0 = 0;
    public static final int BAUD75 = 75;
    public static final int BAUD150 = 150;
    public static final int BAUD300 = 300;
    public static final int BAUD600 = 600;
    public static final int BAUD1200 = 1200;
    public static final int BAUD1800 = 1800;
    public static final int BAUD2400 = 2400;
    public static final int BAUD4800 = 4800;
    public static final int BAUD9600 = 9600;
    public static final int BAUD14400 = 14400;
    public static final int BAUD19200 = 19200;
    public static final int BAUD38400 = 38400;
    public static final int BAUD57600 = 57600;
    public static final int BAUD115200 = 115200;
    public static final int BAUD230400 = 230400;
    public static final int BAUD460800 = 460800;
    public static final int BAUD614400 = 614400;
    public static final int BAUD921600 = 921600;
    public static final int BAUD1228800 = 1228800;
    public static final int BAUD2457600 = 2457600;
    public static final int BAUD3000000 = 3000000;
    public static final int BAUD6000000 = 6000000;
    public static final int BAUD12000000 = 12000000;
    private byte[] mPortSetting = new byte[7];
    static final int PL_SIO_SET_BITMODE_REQUEST = 11;
    static final int PL_SIO_READ_PINS_REQUEST = 12;
    private static final int SET_LINE_REQUEST_TYPE = 33;
    private static final int SET_LINE_REQUEST = 32;
    private static final int BREAK_REQUEST_TYPE = 33;
    private static final int BREAK_REQUEST = 35;
    private static final int BREAK_OFF = 0;
    private static final int GET_LINE_REQUEST_TYPE = 161;
    private static final int GET_LINE_REQUEST = 33;
    private static final int VENDOR_WRITE_REQUEST_TYPE = 64;
    private static final int VENDOR_WRITE_REQUEST = 1;
    private static final int VENDOR_READ_REQUEST_TYPE = 192;
    private static final int VENDOR_READ_REQUEST = 1;
    private static final int SET_CONTROL_REQUEST_TYPE = 33;
    private static final int SET_CONTROL_REQUEST = 34;
    private static final int CONTROL_DTR = 1;
    private static final int CONTROL_RTS = 2;
    public static final int PL_MAX_INTERFACE_NUM = 4;
    private final int mPacketSize = 64;
    private UsbManager mManager;
    private UsbDevice mDevice;
    private UsbDeviceConnection mDeviceConnection;
    private UsbInterface mInterface;
    private UsbEndpoint mPLEndpointBulkIN;
    private UsbEndpoint mPLEndpointBulkOUT;
    private UsbEndpoint mPLEndpointIntr;
    public static final int READBUF_SIZE = 4096;
    public static final int WRITEBUF_SIZE = 4096;
    private int mReadbufOffset;
    private int mReadbufRemain;
    byte[] mReadbuf = new byte[4096];
    private int RdTransferTimeOut;
    private int TdTransferTimeOut;
    private int WrCTRLTransferTimeOut;
    private ArrayBlockingQueue<Integer> iReadQueueArray = new ArrayBlockingQueue(4096, true);
    public static Object ReadQueueLock = new Object();
    private ReadDataThread mThread;
    private boolean iThreadAlive;
    private int incReadCount = 0;
    private int totalReadCount = 0;
    private boolean updateReadCount = false;
    private boolean isRS485Mode = false;
    private String ACTION_USB_PERMISSION;
    private ArrayList<String> Supported_VID_PID = new ArrayList();
    private int iSupportedDevListCnt;
    Context mContext;
    private int mPL2303Type = 0;
    private final int PL2303HXATYPE = 2;
    private final int PL2303HXCTYPE = 3;
    private final int PL2303HXDTYPE = 4;
    private final int PL2303TATYPE = 5;
    private final int PL2303TBTYPE = 6;
    private final int PL2303SATYPE = 7;
    private final int PL2303EATYPE = 8;
    private final int PL2303RATYPE = 9;
    private boolean bHasPermission;
    private boolean bIsPL2551BTYPE;
    private boolean bWithSoftware4KQueue;
    public final String PLUART_MESSAGE = "tw.PL2303USBMessage";
    public final String PLUART_DETACHED = "USB.Detached";
    public final int PLDETACHED_VALUE = 255;
    private int GPIO_01_Data;
    private int GPIO_23_Config;
    private int GPIO_23_Data;
    private int GPIO_4567_Config;
    private int GPIO_4567_Data;
    private int GPIO_4567_Pre_Output_Data;
    private boolean isEEPROM = false;
    private final BroadcastReceiver mPermissionReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
            PL2303Driver.DumpMsg("Enter BroadcastReceiver" + action);
            if ("android.hardware.usb.action.USB_DEVICE_ATTACHED".equals(action)) {
                PL2303Driver.DumpMsg("lib:ACTION_USB_DEVICE_ATTACHED");
            } else if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(action)) {
                String deviceName = device.getDeviceName();
                if (PL2303Driver.this.mDevice != null && PL2303Driver.this.mDevice.equals((Object)deviceName)) {
                    PL2303Driver.DumpMsg("USB interface removed");
                    PL2303Driver.this.end();
                    Intent plIntent = new Intent("tw.PL2303USBMessage");
                    plIntent.putExtra("USB.Detached", String.valueOf(255));
                    PL2303Driver.this.mContext.sendBroadcast(plIntent);
                    Toast.makeText((Context)PL2303Driver.this.mContext, (CharSequence)"disconnect", (int)0).show();
                }
                PL2303Driver.DumpMsg("ACTION_USB_DEVICE_DETACHED");
            } else if (action.equals(PL2303Driver.this.ACTION_USB_PERMISSION)) {
                1 var5_6 = this;
                synchronized (var5_6) {
                    if (!intent.getBooleanExtra("permission", false)) {
                        PL2303Driver.DumpMsg("Permission not granted :(");
                    } else {
                        if (device != null) {
                            int i = 0;
                            while (i < PL2303Driver.this.iSupportedDevListCnt) {
                                if (String.format("%04X:%04X", device.getVendorId(), device.getProductId()).equals(PL2303Driver.this.Supported_VID_PID.get(i))) {
                                    PL2303Driver.this.getInformation(device);
                                    return;
                                }
                                ++i;
                            }
                            PL2303Driver.DumpMsg(String.valueOf(String.format("%04X:%04X", device.getVendorId(), device.getProductId())) + " device not present!");
                        }
                        PL2303Driver.DumpMsg("ACTION_USB_PERMISSION: Permission granted");
                    }
                }
            }
            PL2303Driver.DumpMsg("Leave BroadcastReceiver");
        }
    };
    public static UsbDevice sDevice = null;
    private Runnable mLoop = new Runnable(){

        public void run() {
            UsbDevice dev = sDevice;
            if (!PL2303Driver.this.isConnected()) {
                PL2303Driver.this.setUsbInterfaces(dev);
                PL2303Driver.this.bHasPermission = true;
            }
        }
    };

    private void PL2303DriverInitial(UsbManager manager, Context mContext, String sAppName, boolean bWithQueue) {
        this.mManager = manager;
        this.mReadbufOffset = 0;
        this.mReadbufRemain = 0;
        this.bHasPermission = false;
        this.iThreadAlive = false;
        this.bIsPL2551BTYPE = false;
        this.mContext = mContext;
        this.bWithSoftware4KQueue = bWithQueue;
        this.ACTION_USB_PERMISSION = sAppName;
        this.Set_NewVID_PID("067B:2303");
        this.Set_NewVID_PID("067B:2551");
        this.Set_NewVID_PID("067B:2503");
        this.Set_NewVID_PID("067B:AAA5");
        this.Set_NewVID_PID("0557:2008");
        this.Set_NewVID_PID("05AD:0FBA");
        this.iSupportedDevListCnt = this.Supported_VID_PID.size();
        this.GPIO_01_Data = 0;
        this.GPIO_23_Config = 15;
        this.GPIO_23_Data = 3;
        this.GPIO_4567_Config = 0;
        this.GPIO_4567_Data = 0;
        this.GPIO_4567_Pre_Output_Data = 0;
        this.RdTransferTimeOut = 100;
        this.TdTransferTimeOut = 100;
        this.WrCTRLTransferTimeOut = 100;
    }

    public PL2303Driver(UsbManager manager, Context mContext, String sAppName) {
        this.PL2303DriverInitial(manager, mContext, sAppName, true);
    }

    public PL2303Driver(UsbManager manager, Context mContext, String sAppName, boolean bWithQueue) {
        this.PL2303DriverInitial(manager, mContext, sAppName, bWithQueue);
    }

    private void setUsbInterfaces(UsbDevice device) {
        UsbDeviceConnection connection;
        int UARTintf = 0;
        if (this.mDeviceConnection != null) {
            if (this.mInterface != null) {
                this.mDeviceConnection.releaseInterface(this.mInterface);
                this.mInterface = null;
            }
            this.mDeviceConnection.close();
            this.mDevice = null;
            this.mDeviceConnection = null;
        }
        if (device == null) {
            return;
        }
        int index = 0;
        while (index < device.getInterfaceCount()) {
            UsbInterface intf = device.getInterface(index);
            if (255 == intf.getInterfaceClass() && intf.getInterfaceProtocol() == 0 && intf.getInterfaceSubclass() == 0) {
                UARTintf = index;
                break;
            }
            ++index;
        }
        PL2303Driver.DumpMsg("UARTintf index = " + UARTintf);
        UsbInterface intf = device.getInterface(UARTintf);
        PL2303Driver.DumpMsg("Found " + intf);
        if (device != null && intf != null && (connection = this.mManager.openDevice(device)) != null) {
            if (connection.claimInterface(intf, true)) {
                PL2303Driver.DumpMsg("claim interface succeeded");
                this.mDevice = device;
                this.mDeviceConnection = connection;
                this.mInterface = intf;
                if (this.getPLEndpoints(this.mInterface)) {
                    PL2303Driver.DumpMsg("setPLEndpoints succeeded");
                    return;
                }
                PL2303Driver.DumpMsg("not setPLEndpoints");
            } else {
                PL2303Driver.DumpMsg("claim interface failed");
                connection.close();
            }
        }
        PL2303Driver.DumpMsg("USB interface not found");
    }

    boolean DoubleVerifyDeviceName(String strDevPath) {
        String s = "";
        boolean bResult = true;
        try {
            String cmd = "toolbox ls " + strDevPath;
            PL2303Driver.DumpMsg("cmd:" + cmd);
            Process p = Runtime.getRuntime().exec(cmd);
            BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = null;
            while ((line = in.readLine()) != null) {
                s = String.valueOf(s) + line;
            }
            PL2303Driver.DumpMsg("verify: " + s);
            if (strDevPath.compareTo(s) != 0) {
                bResult = false;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            bResult = false;
        }
        return bResult;
    }

    private boolean Set_NewVID_PID(String vid_pid) {
        this.Supported_VID_PID.add(vid_pid);
        this.iSupportedDevListCnt = this.Supported_VID_PID.size();
        return true;
    }

    public boolean enumerate() {
        PL2303Driver.DumpMsg("enumerating");
        this.mManager = (UsbManager)this.mContext.getSystemService("usb");
        HashMap devlist = this.mManager.getDeviceList();
        Iterator deviter = devlist.values().iterator();
        PendingIntent pi = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)new Intent(this.ACTION_USB_PERMISSION), (int)0);
        while (deviter.hasNext()) {
            UsbDevice d = (UsbDevice)deviter.next();
            PL2303Driver.DumpMsg("Found device: " + String.format("%04X:%04X", d.getVendorId(), d.getProductId()));
            PL2303Driver.DumpMsg("iSupportedDevListCnt: " + this.iSupportedDevListCnt);
            int i = 0;
            while (i < this.iSupportedDevListCnt) {
                if (String.format("%04X:%04X", d.getVendorId(), d.getProductId()).equals(this.Supported_VID_PID.get(i)) && this.DoubleVerifyDeviceName(d.getDeviceName())) {
                    IntentFilter filter = new IntentFilter(this.ACTION_USB_PERMISSION);
                    filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
                    this.mContext.registerReceiver(this.mPermissionReceiver, filter);
                    if (!this.mManager.hasPermission(d)) {
                        this.mManager.requestPermission(d, pi);
                    } else {
                        this.getInformation(d);
                        if (String.format("%04X:%04X", d.getVendorId(), d.getProductId()).equals("067B:2551")) {
                            this.bIsPL2551BTYPE = true;
                        }
                        return true;
                    }
                }
                ++i;
            }
        }
        PL2303Driver.DumpMsg("no more devices found");
        return false;
    }

    private void getInformation(UsbDevice d) {
        sDevice = d;
        new Thread(this.mLoop).start();
    }

    private boolean init() {
        if (!this.bHasPermission) {
            PL2303Driver.DumpMsg("has not permission to access usb device");
            return false;
        }
        if (this.mDevice == null) {
            PL2303Driver.DumpMsg("mDevice == null");
            return false;
        }
        int res = this.initPL2303Chip(this.mDeviceConnection);
        if (res < 0) {
            PL2303Driver.DumpMsg("fail to init:initPL2303Chip" + res);
            return false;
        }
        if (this.mPL2303Type != 4) {
            PL2303Driver.DumpMsg("No PL2303HXD chip");
            return false;
        }
        this.mThread = this.bWithSoftware4KQueue ? new ReadDataThread() : null;
        return true;
    }

    public boolean InitByDefualtValue() {
        if (!this.init()) {
            return false;
        }
        if (this.bWithSoftware4KQueue) {
            this.StartReadThread();
        }
        return true;
    }

    public boolean InitByBaudRate(BaudRate R) {
        if (!this.init()) {
            return false;
        }
        int res = 0;
        try {
            res = this.setup(R, DataBits.D8, StopBits.S1, Parity.NONE, FlowControl.OFF);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (res < 0) {
            PL2303Driver.DumpMsg("fail to InitByBaudRate" + (Object)((Object)R) + "res:" + res);
            return false;
        }
        if (this.bWithSoftware4KQueue) {
            this.StartReadThread();
        }
        return true;
    }

    public boolean InitByBaudRate(BaudRate R, int TimeoutConstant) {
        if (!this.init()) {
            return false;
        }
        int res = 0;
        try {
            res = this.setup(R, DataBits.D8, StopBits.S1, Parity.NONE, FlowControl.OFF);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (res < 0) {
            PL2303Driver.DumpMsg("fail to InitByBaudRate" + (Object)((Object)R) + "res:" + res);
            return false;
        }
        if (!this.PL2303Device_SetCommTimeouts(TimeoutConstant)) {
            return false;
        }
        if (this.bWithSoftware4KQueue) {
            this.StartReadThread();
        }
        return true;
    }

    public boolean InitByPortSetting(BaudRate R, DataBits D, StopBits S, Parity P, FlowControl F) {
        if (!this.init()) {
            return false;
        }
        int res = 0;
        try {
            res = this.setup(R, D, S, P, F);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (res < 0) {
            PL2303Driver.DumpMsg("fail to InitByPortSetting");
            return false;
        }
        if (this.bWithSoftware4KQueue) {
            this.StartReadThread();
        }
        return true;
    }

    public void end() {
        if (this.mDevice != null) {
            if (this.bWithSoftware4KQueue) {
                this.StopReadThread();
            }
            this.bIsPL2551BTYPE = false;
            this.mContext.unregisterReceiver(this.mPermissionReceiver);
            this.setUsbInterfaces(null);
        }
    }

    public boolean isConnected() {
        return this.mDevice != null && this.mPLEndpointBulkIN != null && this.mPLEndpointBulkOUT != null;
    }

    private boolean getPLEndpoints(UsbInterface usbIf) {
        if (usbIf == null) {
            return false;
        }
        int i = 0;
        while (i < usbIf.getEndpointCount()) {
            PL2303Driver.DumpMsg("EP: " + String.format("0x%02X", usbIf.getEndpoint(i).getAddress()));
            if (usbIf.getEndpoint(i).getType() == 2) {
                PL2303Driver.DumpMsg("Bulk Endpoint");
                if (usbIf.getEndpoint(i).getDirection() == 128) {
                    this.mPLEndpointBulkIN = usbIf.getEndpoint(i);
                } else {
                    this.mPLEndpointBulkOUT = usbIf.getEndpoint(i);
                }
            } else if (usbIf.getEndpoint(i).getType() == 3) {
                if (usbIf.getEndpoint(i).getDirection() == 128) {
                    this.mPLEndpointIntr = usbIf.getEndpoint(i);
                }
            } else {
                PL2303Driver.DumpMsg("Not any ep");
            }
            ++i;
        }
        return true;
    }

    private void StartReadThread() {
        if (!this.iThreadAlive) {
            this.mThread.start();
            this.iThreadAlive = this.mThread.isAlive();
            PL2303Driver.DumpMsg("Start ReadThread:" + this.iThreadAlive);
        }
    }

    private void StopReadThread() {
        if (this.iThreadAlive && this.mThread != null) {
            this.mThread.StopReadDataThread();
            this.iThreadAlive = this.mThread.isAlive();
            this.mThread = null;
            PL2303Driver.DumpMsg("Stop ReadThread:" + this.iThreadAlive);
        }
    }

    private void SetThreadDelayTime(BaudRate R) {
        int[] DelayTimeLevel = new int[]{10, 20, 25, 50, 100, 200};
        int time = DelayTimeLevel[3];
        switch (R) {
            case B1228800: 
            case B2457600: 
            case B3000000: 
            case B6000000: {
                time = DelayTimeLevel[0];
                break;
            }
            case B115200: 
            case B230400: 
            case B460800: 
            case B614400: 
            case B921600: {
                time = DelayTimeLevel[1];
                break;
            }
            case B14400: 
            case B19200: 
            case B38400: 
            case B57600: {
                time = DelayTimeLevel[2];
                break;
            }
            case B1200: 
            case B1800: 
            case B2400: 
            case B4800: 
            case B9600: {
                time = DelayTimeLevel[3];
                break;
            }
            case B300: 
            case B600: {
                time = DelayTimeLevel[4];
                break;
            }
            case B75: 
            case B150: {
                time = DelayTimeLevel[5];
                break;
            }
            case B0: {
                time = 10000;
                break;
            }
            default: {
                PL2303Driver.DumpMsg("Baudrate not supported");
                return;
            }
        }
        PL2303Driver.DumpMsg("baudrate:" + (Object)((Object)R) + "; time:" + time);
        if (this.mThread != null) {
            this.mThread.SetDelayTimeMS(time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] buf) {
        int ret = 0;
        int buflen = buf.length;
        if (buflen == 0) {
            PL2303Driver.DumpMsg("buf length :no data ");
            return 0;
        }
        if (buflen > 4096) {
            PL2303Driver.DumpMsg("buf length over READBUF_SIZE, re-assign buf size");
            buf = new byte[4096];
        }
        if (this.bWithSoftware4KQueue) {
            Object object = ReadQueueLock;
            synchronized (object) {
                int queuelen = this.iReadQueueArray.size();
                if (queuelen > 0) {
                    PL2303Driver.DumpMsg("QueueCount=" + queuelen);
                    ret = buflen >= queuelen ? queuelen : buflen;
                    int i = 0;
                    while (i < ret) {
                        Integer mdata = this.iReadQueueArray.poll();
                        if (mdata == null) {
                            PL2303Driver.DumpMsg("this queue is empty" + ret);
                            break;
                        }
                        buf[i] = (byte)(mdata & 0xFF);
                        ++i;
                    }
                } else {
                    ret = 0;
                }
            }
        }
        int queuelen = this.ReadFromHW(buf, buflen);
        if (queuelen > 0) {
            ret = buflen >= queuelen ? queuelen : buflen;
        }
        return ret;
    }

    private int ReadFromHW(byte[] buf, int rlength) {
        int len;
        if (buf.length == 0 || rlength == 0) {
            PL2303Driver.DumpMsg("buf length :no data ");
            return 0;
        }
        if (this.mReadbufRemain > 0 && rlength <= this.mReadbufRemain) {
            if (!this.mReadPakcetChecker) {
                System.arraycopy(this.mReadbuf, this.mReadbufOffset, buf, 0, rlength);
            } else {
                int i = 0;
                while (i < rlength) {
                    buf[i] = this.mReadbuf[this.mReadbufOffset++];
                    ++this.incReadCount;
                    while ((this.incReadCount - 1) % 10 != Byte.valueOf(buf[i]) - 48) {
                        PL2303Driver.DumpMsg("!!! Lost Data !!! count : " + (this.incReadCount - 1) + ", data : " + buf[i]);
                        ++this.incReadCount;
                    }
                    ++i;
                }
                PL2303Driver.DumpMsg("read buf length 1 : " + Integer.toString(rlength));
                this.totalReadCount += rlength;
                this.updateReadCount = true;
            }
            this.mReadbufRemain -= rlength;
            return rlength;
        }
        int ofst = 0;
        int needlen = rlength;
        PL2303Driver.DumpMsg("RdTransferTimeOut " + String.valueOf(this.RdTransferTimeOut));
        if (this.mReadbufRemain > 0) {
            needlen -= this.mReadbufRemain;
            System.arraycopy(this.mReadbuf, this.mReadbufOffset, buf, ofst, this.mReadbufRemain);
        }
        if ((len = this.mDeviceConnection.bulkTransfer(this.mPLEndpointBulkIN, this.mReadbuf, this.mReadbuf.length, this.RdTransferTimeOut)) < 0) {
            return len;
        }
        if (len == 0) {
            return 0;
        }
        PL2303Driver.DumpMsg("ReadFromHW:Read Length:" + len + ";data=" + new String(this.mReadbuf).substring(0, len));
        int blocks = len / 64;
        int remain = len % 64;
        if (remain > 0) {
            ++blocks;
        }
        this.mReadbufRemain = len;
        int rbufindex = 0;
        int block = 0;
        while (block < blocks) {
            int blockofst = block * 64;
            int i = 0;
            while (i < 64) {
                this.mReadbuf[rbufindex++] = this.mReadbuf[blockofst + i];
                ++i;
            }
            ++block;
        }
        this.mReadbufOffset = 0;
        while (this.mReadbufRemain > 0 && needlen > 0) {
            buf[ofst++] = this.mReadbuf[this.mReadbufOffset++];
            if (this.mReadPakcetChecker) {
                ++this.incReadCount;
                while ((this.incReadCount - 1) % 10 != Byte.valueOf(buf[ofst - 1]) - 48) {
                    PL2303Driver.DumpMsg("!!! Lost Data !!! count : " + (this.incReadCount - 1) + ", data : " + Byte.toString(buf[ofst - 1]));
                    ++this.incReadCount;
                }
            }
            --this.mReadbufRemain;
            --needlen;
        }
        if (this.mReadPakcetChecker) {
            if (ofst > 0) {
                PL2303Driver.DumpMsg("read buf length 2 : " + Integer.toString(ofst));
                this.totalReadCount += ofst;
                this.updateReadCount = true;
            }
            if (this.updateReadCount) {
                PL2303Driver.DumpMsg("Total of Read Count : " + this.totalReadCount);
                PL2303Driver.DumpMsg("Increment Read Count : " + this.incReadCount);
                this.updateReadCount = false;
            }
        }
        return ofst;
    }

    public int write(byte[] buf) {
        return this.write(buf, buf.length);
    }

    public int write(byte[] buf, int wlength) {
        int offset = 0;
        byte[] write_buf = new byte[4096];
        PL2303Driver.DumpMsg("TdTransferTimeOut" + String.valueOf(this.TdTransferTimeOut));
        while (offset < wlength) {
            int write_size = 4096;
            if (offset + write_size > wlength) {
                write_size = wlength - offset;
            }
            System.arraycopy(buf, offset, write_buf, 0, write_size);
            PL2303Driver.DumpMsg("offset:" + offset + ",write_size:" + write_size + ",wlength:" + wlength);
            int actual_length = this.mDeviceConnection.bulkTransfer(this.mPLEndpointBulkOUT, write_buf, write_size, this.TdTransferTimeOut);
            if (actual_length < 0) {
                PL2303Driver.DumpMsg("fail to write:" + actual_length);
                return -1;
            }
            offset += actual_length;
        }
        PL2303Driver.DumpMsg("Write Length:" + offset + ";" + new String(write_buf).substring(0, offset));
        return offset;
    }

    public int setup(BaudRate R, DataBits D, StopBits S, Parity P, FlowControl F) throws IOException {
        int res = 0;
        if (this.mDeviceConnection == null) {
            PL2303Driver.DumpMsg("Connection closed");
            return -1;
        }
        res = this.mDeviceConnection.controlTransfer(161, 33, 0, 0, this.mPortSetting, 7, this.WrCTRLTransferTimeOut);
        if (res < 0) {
            PL2303Driver.DumpMsg("fail to setup:get line request");
            return res;
        }
        PL2303Driver.DumpMsg("Current serial configuration:" + this.mPortSetting[0] + "," + this.mPortSetting[1] + "," + this.mPortSetting[2] + "," + this.mPortSetting[3] + "," + this.mPortSetting[4] + "," + this.mPortSetting[5] + "," + this.mPortSetting[6]);
        int baud = 0;
        switch (R) {
            case B0: {
                baud = 0;
                break;
            }
            case B75: {
                baud = 75;
                break;
            }
            case B150: {
                baud = 150;
                break;
            }
            case B300: {
                baud = 300;
                break;
            }
            case B600: {
                baud = 600;
                break;
            }
            case B1200: {
                baud = 1200;
                break;
            }
            case B1800: {
                baud = 1800;
                break;
            }
            case B2400: {
                baud = 2400;
                break;
            }
            case B4800: {
                baud = 4800;
                break;
            }
            case B9600: {
                baud = 9600;
                break;
            }
            case B14400: {
                baud = 14400;
                break;
            }
            case B19200: {
                baud = 19200;
                break;
            }
            case B38400: {
                baud = 38400;
                break;
            }
            case B57600: {
                baud = 57600;
                break;
            }
            case B115200: {
                baud = 115200;
                break;
            }
            case B230400: {
                baud = 230400;
                break;
            }
            case B460800: {
                baud = 460800;
                break;
            }
            case B614400: {
                baud = 614400;
                break;
            }
            case B921600: {
                baud = 921600;
                break;
            }
            case B1228800: {
                baud = 1228800;
                break;
            }
            case B2457600: {
                baud = 2457600;
                break;
            }
            case B3000000: {
                baud = 3000000;
                break;
            }
            case B6000000: {
                baud = 6000000;
                break;
            }
            default: {
                PL2303Driver.DumpMsg("Baudrate not supported");
                return -2;
            }
        }
        if (baud > 1228800 && this.mPL2303Type == 0) {
            PL2303Driver.DumpMsg("Baudrate not supported: Only PL2303HX supports the higher baudrates");
            return -2;
        }
        if (this.mThread != null) {
            this.SetThreadDelayTime(R);
            PL2303Driver.DumpMsg("SetThreadDelayTime:" + baud);
        }
        PL2303Driver.DumpMsg("setup:" + baud);
        this.mPortSetting[0] = (byte)(baud & 0xFF);
        this.mPortSetting[1] = (byte)(baud >> 8 & 0xFF);
        this.mPortSetting[2] = (byte)(baud >> 16 & 0xFF);
        this.mPortSetting[3] = (byte)(baud >> 24 & 0xFF);
        switch (S) {
            case S1: {
                this.mPortSetting[4] = 0;
                break;
            }
            case S2: {
                this.mPortSetting[4] = 2;
                break;
            }
            default: {
                PL2303Driver.DumpMsg("Stopbit setting not supported");
                return -3;
            }
        }
        switch (P) {
            case NONE: {
                this.mPortSetting[5] = 0;
                break;
            }
            case ODD: {
                this.mPortSetting[5] = 1;
                break;
            }
            case EVEN: {
                this.mPortSetting[5] = 2;
                break;
            }
            default: {
                PL2303Driver.DumpMsg("Parity setting not supported");
                return -4;
            }
        }
        switch (D) {
            case D5: {
                this.mPortSetting[6] = 5;
                break;
            }
            case D6: {
                this.mPortSetting[6] = 6;
                break;
            }
            case D7: {
                this.mPortSetting[6] = 7;
                break;
            }
            case D8: {
                this.mPortSetting[6] = 8;
                break;
            }
            default: {
                PL2303Driver.DumpMsg("Databit setting not supported");
                return -5;
            }
        }
        res = this.mDeviceConnection.controlTransfer(33, 32, 0, 0, this.mPortSetting, 7, this.WrCTRLTransferTimeOut);
        if (res < 0) {
            PL2303Driver.DumpMsg("Error in setting serial configuration");
            return res;
        }
        PL2303Driver.DumpMsg("New serial configuration:" + this.mPortSetting[0] + "," + this.mPortSetting[1] + "," + this.mPortSetting[2] + "," + this.mPortSetting[3] + "," + this.mPortSetting[4] + "," + this.mPortSetting[5] + "," + this.mPortSetting[6]);
        res = this.mDeviceConnection.controlTransfer(33, 35, 0, 0, null, 0, this.WrCTRLTransferTimeOut);
        if (res < 0) {
            PL2303Driver.DumpMsg("fail to setup:break off");
            return res;
        }
        switch (F) {
            case OFF: {
                res = this.mDeviceConnection.controlTransfer(64, 1, 0, 0, null, 0, this.WrCTRLTransferTimeOut);
                if (res < 0) {
                    PL2303Driver.DumpMsg("fail to setup:write request");
                    return res;
                }
                PL2303Driver.DumpMsg("FlowControl disabled");
                break;
            }
            case RTSCTS: {
                res = this.mDeviceConnection.controlTransfer(64, 1, 0, 65, null, 0, this.WrCTRLTransferTimeOut);
                if (res < 0) {
                    PL2303Driver.DumpMsg("fail to setup");
                    return res;
                }
                PL2303Driver.DumpMsg("RTS/CTS FlowControl enabled");
                break;
            }
            case RFRCTS: {
                break;
            }
            case DTRDSR: {
                if (4 != this.mPL2303Type || (res = this.mDeviceConnection.controlTransfer(64, 1, 0, 8, null, 0, this.WrCTRLTransferTimeOut)) >= 0) break;
                PL2303Driver.DumpMsg("fail to setup");
                return res;
            }
            case XONXOFF: {
                res = this.mDeviceConnection.controlTransfer(64, 1, 0, 192, null, 0, this.WrCTRLTransferTimeOut);
                if (res >= 0) break;
                PL2303Driver.DumpMsg("fail to setup");
                return res;
            }
            default: {
                PL2303Driver.DumpMsg("failed to FlowControl ");
                return -6;
            }
        }
        if (this.isRS485Mode) {
            PL2303Driver.DumpMsg("RS485 Mode detected");
            res = this.SetPL2303VendorCommand(0, 49);
            if (res < 0) {
                PL2303Driver.DumpMsg("fail to Set RS485 CommandA");
                return res;
            }
            res = this.SetPL2303VendorCommand(1, 8);
            if (res < 0) {
                PL2303Driver.DumpMsg("fail to Set RS485 CommandB");
                return res;
            }
        }
        return 0;
    }

    private int initPL2303Chip(UsbDeviceConnection conn) {
        int res = 0;
        int[] res2 = new int[2];
        res2[0] = 0;
        if (this.bIsPL2551BTYPE) {
            this.mPL2303Type = 4;
        } else {
            if (!this.PL2303_IsEEPROM067B()) {
                PL2303Driver.DumpMsg("Init PL2303HW");
                res = this.PL2303_InitHW();
                if (res < 0) {
                    return res;
                }
            }
            if (conn.getRawDescriptors()[13] == 4) {
                this.mPL2303Type = 4;
            }
            if ((res = this.checkPL2303ChipType()) < 0) {
                return res;
            }
            if (this.isEEPROM && (res = this.checkRS485Mode()) < 0) {
                return res;
            }
        }
        if (this.mPL2303Type != 4) {
            return -1;
        }
        PL2303Driver.DumpMsg("mPL2303Type=" + this.mPL2303Type);
        int j = 128;
        while (j <= 130) {
            res2 = this.GetPL2303VendorCommand(j);
            if (res2[0] < 0) {
                if (bDebugMesg_EEPROMCommand) {
                    PL2303Driver.DumpMsg("fail GetPL2303_EEPROMData;");
                }
                return res2[0];
            }
            PL2303Driver.DumpMsg("DCR[" + (j - 128) + "] = 0x" + this.IntToHex2(res2[1]));
            ++j;
        }
        try {
            res = this.setup(BaudRate.B9600, DataBits.D8, StopBits.S1, Parity.NONE, FlowControl.OFF);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (res2[0] < 0) {
            PL2303Driver.DumpMsg("fail to initPL2303Chip: setup");
            return res;
        }
        return 0;
    }

    private int checkPL2303ChipType() {
        int[] res2 = new int[2];
        int checkValue = 255;
        int[] verValue = new int[2];
        res2 = this.GetPL2303VendorCommand(129);
        if (res2[0] < 0) {
            PL2303Driver.DumpMsg("fail checkPL2303ChipType;");
            return res2[0];
        }
        PL2303Driver.DumpMsg("old Config Value:0x" + this.IntToHex2(res2[1]));
        int oldConfigValue = res2[1];
        res2[0] = this.SetPL2303VendorCommand(1, checkValue);
        if (res2[0] < 0) {
            PL2303Driver.DumpMsg("fail checkPL2303ChipType;");
            return res2[0];
        }
        res2 = this.GetPL2303VendorCommand(129);
        if (res2[0] < 0) {
            PL2303Driver.DumpMsg("fail checkPL2303ChipType;");
            return res2[0];
        }
        PL2303Driver.DumpMsg("checkPL2303ChipType data: 0x" + this.IntToHex2(res2[1]));
        if ((res2[1] & 0xF) == 15) {
            PL2303Driver.DumpMsg("PL2303 D serial");
            this.mPL2303Type = 4;
            res2 = this.GetPL2303_EEPROMData(250);
            if (res2[0] < 0) {
                PL2303Driver.DumpMsg("fail checkPL2303ChipType;");
                return res2[0];
            }
            PL2303Driver.DumpMsg("FA data: 0x" + this.IntToHex2(res2[1]));
            verValue[0] = res2[1];
            res2 = this.GetPL2303_EEPROMData(251);
            if (res2[0] < 0) {
                PL2303Driver.DumpMsg("fail checkPL2303ChipType;");
                return res2[0];
            }
            PL2303Driver.DumpMsg("FB data: 0x" + this.IntToHex2(res2[1]));
            verValue[1] = res2[1];
            if (verValue[0] == 1 && verValue[1] == 4) {
                PL2303Driver.DumpMsg("PL2303SA chip");
                this.mPL2303Type = 2;
            } else if (verValue[0] == 2 && verValue[1] == 4) {
                PL2303Driver.DumpMsg("PL2303EA chip");
            } else if (verValue[0] == 3 && verValue[1] == 4) {
                PL2303Driver.DumpMsg("PL2303RA chip");
            } else if (verValue[0] == 1 && verValue[1] == 3) {
                PL2303Driver.DumpMsg("PL2303HXC chip");
                this.mPL2303Type = 2;
            } else {
                PL2303Driver.DumpMsg("PL2303HXD chip");
            }
        } else {
            PL2303Driver.DumpMsg("PL2303 A serial");
            this.mPL2303Type = 2;
        }
        res2[0] = this.SetPL2303VendorCommand(1, oldConfigValue);
        if (res2[0] < 0) {
            PL2303Driver.DumpMsg("fail checkPL2303ChipType;");
            return res2[0];
        }
        return 0;
    }

    private String IntToHex2(int Value) {
        char[] HEX2 = new char[]{Character.forDigit(Value >> 4 & 0xF, 16), Character.forDigit(Value & 0xF, 16)};
        String Hex2Str = new String(HEX2);
        return Hex2Str;
    }

    private int checkRS485Mode() {
        int[] res2 = new int[2];
        res2 = this.GetPL2303VendorCommand(129);
        if (res2[0] < 0) {
            PL2303Driver.DumpMsg("fail checkRS485Mode;");
            return res2[0];
        }
        PL2303Driver.DumpMsg("DCR[1] = 0x" + this.IntToHex2(res2[1]));
        if ((res2[1] & 8) == 8) {
            res2[0] = this.SetPL2303VendorCommand(0, 49);
            if (res2[0] < 0) {
                PL2303Driver.DumpMsg("fail checkRS485Mode;");
                return res2[0];
            }
            res2[0] = this.SetPL2303VendorCommand(1, 8);
            if (res2[0] < 0) {
                PL2303Driver.DumpMsg("fail checkRS485Mode;");
                return res2[0];
            }
            PL2303Driver.DumpMsg("RS485 Mode detected");
            this.isRS485Mode = true;
        }
        return res2[0];
    }

    public int PL2303HXD_Enable_GPIO(int GPIO_Num, boolean Enable) {
        int[] res2 = new int[2];
        int newData = 0;
        PL2303Driver.DumpMsg("Enter Enable_GPIO ");
        if (this.mDeviceConnection == null) {
            PL2303Driver.DumpMsg("Connection closed");
            return -1;
        }
        switch (GPIO_Num) {
            case 0: {
                res2 = this.GetPL2303VendorCommand(129);
                if (res2[0] < 0) {
                    PL2303Driver.DumpMsg("fail GetPL2303VendorCommand;");
                    return res2[0];
                }
                PL2303Driver.DumpMsg("DCR 1 buffer: 0x" + this.IntToHex2(res2[1]));
                newData = Enable ? (res2[1] = res2[1] | 0x10) : (res2[1] = res2[1] & 0xFFFFFFEF);
                res2[0] = this.SetPL2303VendorCommand(1, newData);
                if (res2[0] < 0) {
                    PL2303Driver.DumpMsg("fail SetPL2303VendorCommand;");
                    return res2[0];
                }
                PL2303Driver.DumpMsg("Exit GP0_OUTPUT_ENABLE-- enable: " + Enable);
                break;
            }
            case 1: {
                res2 = this.GetPL2303VendorCommand(129);
                if (res2[0] < 0) {
                    PL2303Driver.DumpMsg("fail GetPL2303VendorCommand;");
                    return res2[0];
                }
                PL2303Driver.DumpMsg("DCR 1 buffer: 0x" + this.IntToHex2(res2[1]));
                newData = Enable ? (res2[1] = res2[1] | 0x20) : (res2[1] = res2[1] & 0xFFFFFFDF);
                res2[0] = this.SetPL2303VendorCommand(1, newData);
                if (res2[0] < 0) {
                    PL2303Driver.DumpMsg("fail SetPL2303VendorCommand;");
                    return res2[0];
                }
                PL2303Driver.DumpMsg("Exit GP1_OUTPUT_ENABLE-- enable: " + Enable);
                break;
            }
            case 2: {
                PL2303Driver.DumpMsg("GPIO 2_3 conf : 0x" + this.IntToHex2(this.GPIO_23_Config));
                this.GPIO_23_Config = Enable ? (this.GPIO_23_Config |= 3) : (this.GPIO_23_Config &= 0xFFFFFFFC);
                res2[0] = this.SetPL2303VendorCommand(12, this.GPIO_23_Config);
                if (res2[0] < 0) {
                    PL2303Driver.DumpMsg("fail SetPL2303VendorCommand;");
                    return res2[0];
                }
                PL2303Driver.DumpMsg("Enable GP2: " + String.valueOf(Enable) + " New GPIO 2_3 conf : 0x" + this.IntToHex2(this.GPIO_23_Config));
                PL2303Driver.DumpMsg("Exit GP2_OUTPUT_ENABLE-- enable: " + Enable);
                break;
            }
            case 3: {
                PL2303Driver.DumpMsg("GPIO 2_3 conf : 0x" + this.IntToHex2(this.GPIO_23_Config));
                this.GPIO_23_Config = Enable ? (this.GPIO_23_Config |= 0xC) : (this.GPIO_23_Config &= 0xFFFFFFF3);
                res2[0] = this.SetPL2303VendorCommand(12, this.GPIO_23_Config);
                if (res2[0] < 0) {
                    PL2303Driver.DumpMsg("fail SetPL2303VendorCommand;");
                    return res2[0];
                }
                PL2303Driver.DumpMsg("Enabl GP3: " + String.valueOf(Enable) + " New GPIO 2_3 conf : 0x" + this.IntToHex2(this.GPIO_23_Config));
                PL2303Driver.DumpMsg("Exit GP3_OUTPUT_ENABLE-- enable: " + Enable);
                break;
            }
            case 4: {
                PL2303Driver.DumpMsg("GPIO 4567 conf : 0x" + this.IntToHex2(this.GPIO_4567_Config));
                this.GPIO_4567_Config = Enable ? (this.GPIO_4567_Config |= 3) : (this.GPIO_4567_Config &= 0xFFFFFFFC);
                res2[0] = this.SetPL2303VendorCommand(6, this.GPIO_4567_Config);
                PL2303Driver.DumpMsg("Enabl GP4: " + String.valueOf(Enable) + " New GPIO 4567 conf : 0x" + this.IntToHex2(this.GPIO_4567_Config));
                PL2303Driver.DumpMsg("Exit GP4_OUTPUT_ENABLE-- enable: " + Enable);
                break;
            }
            case 5: {
                PL2303Driver.DumpMsg("GPIO 4567 conf : 0x" + this.IntToHex2(this.GPIO_4567_Config));
                this.GPIO_4567_Config = Enable ? (this.GPIO_4567_Config |= 0xC) : (this.GPIO_4567_Config &= 0xFFFFFFF3);
                res2[0] = this.SetPL2303VendorCommand(6, this.GPIO_4567_Config);
                PL2303Driver.DumpMsg("Enabl GP5: " + String.valueOf(Enable) + " New GPIO 4567 conf : 0x" + this.IntToHex2(this.GPIO_4567_Config));
                PL2303Driver.DumpMsg("Exit GP5_OUTPUT_ENABLE-- enable: " + Enable);
                break;
            }
            case 6: {
                PL2303Driver.DumpMsg("GPIO 4567 conf : 0x" + this.IntToHex2(this.GPIO_4567_Config));
                this.GPIO_4567_Config = Enable ? (this.GPIO_4567_Config |= 0x30) : (this.GPIO_4567_Config &= 0xFFFFFFCF);
                res2[0] = this.SetPL2303VendorCommand(6, this.GPIO_4567_Config);
                PL2303Driver.DumpMsg("Enabl GP6: " + String.valueOf(Enable) + " New GPIO 4567 conf : 0x" + this.IntToHex2(this.GPIO_4567_Config));
                PL2303Driver.DumpMsg("Exit GP6_OUTPUT_ENABLE-- enable: " + Enable);
                break;
            }
            case 7: {
                PL2303Driver.DumpMsg("GPIO 4567 conf : 0x" + this.IntToHex2(this.GPIO_4567_Config));
                this.GPIO_4567_Config = Enable ? (this.GPIO_4567_Config |= 0xC0) : (this.GPIO_4567_Config &= 0xFFFFFF3F);
                res2[0] = this.SetPL2303VendorCommand(6, this.GPIO_4567_Config);
                PL2303Driver.DumpMsg("Enabl GP7: " + String.valueOf(Enable) + " New GPIO 4567 conf : 0x" + this.IntToHex2(this.GPIO_4567_Config));
                PL2303Driver.DumpMsg("Exit GP7_OUTPUT_ENABLE-- enable: " + Enable);
                break;
            }
            default: {
                PL2303Driver.DumpMsg("No GPIO number");
                return -1;
            }
        }
        PL2303Driver.DumpMsg("Exit Enable_GPIO ");
        return 0;
    }

    public int PL2303HXD_Set_GPIO_Value(int GPIO_Num, int val) {
        int[] res2 = new int[2];
        int newData = 0;
        PL2303Driver.DumpMsg("Enter PL2303HXD_Set_GPIO_Value ");
        if (this.mDeviceConnection == null) {
            PL2303Driver.DumpMsg("Connection closed");
            return -1;
        }
        switch (GPIO_Num) {
            case 0: {
                res2 = this.GetPL2303VendorCommand(129);
                if (res2[0] < 0) {
                    PL2303Driver.DumpMsg("fail GetPL2303VendorCommand;");
                    return res2[0];
                }
                PL2303Driver.DumpMsg("DCR 1 buffer: 0x" + this.IntToHex2(res2[1]));
                newData = val == 1 ? (res2[1] = res2[1] | 0x40) : (res2[1] = res2[1] & 0xFFFFFFBF);
                res2[0] = this.SetPL2303VendorCommand(1, newData);
                if (res2[0] < 0) {
                    PL2303Driver.DumpMsg("fail GetPL2303VendorCommand;");
                    return res2[0];
                }
                PL2303Driver.DumpMsg("Exit GP0_SET_VALUE-- val: 0x" + val);
                break;
            }
            case 1: {
                res2 = this.GetPL2303VendorCommand(129);
                if (res2[0] < 0) {
                    PL2303Driver.DumpMsg("fail GetPL2303VendorCommand;");
                    return res2[0];
                }
                PL2303Driver.DumpMsg("DCR 1 buffer: 0x" + this.IntToHex2(res2[1]));
                newData = val == 1 ? (res2[1] = res2[1] | 0x80) : (res2[1] = res2[1] & 0xFFFFFF7F);
                res2[0] = this.SetPL2303VendorCommand(1, newData);
                if (res2[0] < 0) {
                    PL2303Driver.DumpMsg("fail GetPL2303VendorCommand;");
                    return res2[0];
                }
                PL2303Driver.DumpMsg("Exit GP1_SET_VALUE-- val: 0x" + val);
                break;
            }
            case 2: {
                res2 = this.GetPL2303VendorCommand(141);
                if (res2[0] < 0) {
                    PL2303Driver.DumpMsg("fail GetPL2303VendorCommand;");
                    return res2[0];
                }
                PL2303Driver.DumpMsg("GPIO23 data: 0x" + this.IntToHex2(res2[1]));
                newData = val == 1 ? (res2[1] = res2[1] | 1) : (res2[1] = res2[1] & 0xFFFFFFFE);
                PL2303Driver.DumpMsg("GPIO23 new data: 0x" + this.IntToHex2(newData));
                res2[0] = this.SetPL2303VendorCommand(13, newData);
                if (res2[0] < 0) {
                    PL2303Driver.DumpMsg("fail GetPL2303VendorCommand;");
                    return res2[0];
                }
                PL2303Driver.DumpMsg("Exit GP2_SET_VALUE-- val: 0x" + val);
                break;
            }
            case 3: {
                res2 = this.GetPL2303VendorCommand(141);
                if (res2[0] < 0) {
                    PL2303Driver.DumpMsg("fail GetPL2303VendorCommand;");
                    return res2[0];
                }
                PL2303Driver.DumpMsg("GPIO23 data: 0x" + this.IntToHex2(res2[1]));
                newData = val == 1 ? (res2[1] = res2[1] | 2) : (res2[1] = res2[1] & 0xFFFFFFFD);
                PL2303Driver.DumpMsg("GPIO23 new data: 0x" + this.IntToHex2(newData));
                res2[0] = this.SetPL2303VendorCommand(13, newData);
                if (res2[0] < 0) {
                    PL2303Driver.DumpMsg("fail GetPL2303VendorCommand;");
                    return res2[0];
                }
                PL2303Driver.DumpMsg("Exit GP3_SET_VALUE-- val: 0x" + val);
                break;
            }
            case 4: {
                PL2303Driver.DumpMsg("GPIO4567 data: 0x" + this.IntToHex2(this.GPIO_4567_Pre_Output_Data));
                this.GPIO_4567_Data = this.GPIO_4567_Pre_Output_Data == 0 ? 0 : this.GPIO_4567_Pre_Output_Data;
                this.GPIO_4567_Data = val == 1 ? (this.GPIO_4567_Data |= 1) : (this.GPIO_4567_Data &= 0xFFFFFFFE);
                this.GPIO_4567_Pre_Output_Data = this.GPIO_4567_Data;
                PL2303Driver.DumpMsg("GPIO4567 new data: 0x" + this.IntToHex2(this.GPIO_4567_Data));
                res2[0] = this.SetPL2303VendorCommand(7, this.GPIO_4567_Data);
                if (res2[0] < 0) {
                    PL2303Driver.DumpMsg("fail GetPL2303VendorCommand;");
                    return res2[0];
                }
                PL2303Driver.DumpMsg("Exit GP4_SET_VALUE-- val: 0x" + val);
                break;
            }
            case 5: {
                PL2303Driver.DumpMsg("GPIO4567 data: 0x" + this.IntToHex2(this.GPIO_4567_Pre_Output_Data));
                this.GPIO_4567_Data = this.GPIO_4567_Pre_Output_Data == 0 ? 0 : this.GPIO_4567_Pre_Output_Data;
                this.GPIO_4567_Data = val == 1 ? (this.GPIO_4567_Data |= 2) : (this.GPIO_4567_Data &= 0xFFFFFFFD);
                this.GPIO_4567_Pre_Output_Data = this.GPIO_4567_Data;
                PL2303Driver.DumpMsg("GPIO4567 new data: 0x" + this.IntToHex2(this.GPIO_4567_Data));
                res2[0] = this.SetPL2303VendorCommand(7, this.GPIO_4567_Data);
                if (res2[0] < 0) {
                    PL2303Driver.DumpMsg("fail GetPL2303VendorCommand;");
                    return res2[0];
                }
                PL2303Driver.DumpMsg("Exit GP5_SET_VALUE-- val: 0x" + val);
                break;
            }
            case 6: {
                PL2303Driver.DumpMsg("GPIO4567 data: 0x" + this.IntToHex2(this.GPIO_4567_Pre_Output_Data));
                this.GPIO_4567_Data = this.GPIO_4567_Pre_Output_Data == 0 ? 0 : this.GPIO_4567_Pre_Output_Data;
                this.GPIO_4567_Data = val == 1 ? (this.GPIO_4567_Data |= 4) : (this.GPIO_4567_Data &= 0xFFFFFFFB);
                this.GPIO_4567_Pre_Output_Data = this.GPIO_4567_Data;
                PL2303Driver.DumpMsg("GPIO4567 new data: 0x" + this.IntToHex2(this.GPIO_4567_Data));
                res2[0] = this.SetPL2303VendorCommand(7, this.GPIO_4567_Data);
                if (res2[0] < 0) {
                    PL2303Driver.DumpMsg("fail GetPL2303VendorCommand;");
                    return res2[0];
                }
                PL2303Driver.DumpMsg("Exit GP6_SET_VALUE-- val: 0x" + val);
                break;
            }
            case 7: {
                PL2303Driver.DumpMsg("GPIO4567 data: 0x" + this.IntToHex2(this.GPIO_4567_Pre_Output_Data));
                this.GPIO_4567_Data = this.GPIO_4567_Pre_Output_Data == 0 ? 0 : this.GPIO_4567_Pre_Output_Data;
                this.GPIO_4567_Data = val == 1 ? (this.GPIO_4567_Data |= 8) : (this.GPIO_4567_Data &= 0xFFFFFFF7);
                this.GPIO_4567_Pre_Output_Data = this.GPIO_4567_Data;
                PL2303Driver.DumpMsg("GPIO4567 new data: 0x" + this.IntToHex2(this.GPIO_4567_Data));
                res2[0] = this.SetPL2303VendorCommand(7, this.GPIO_4567_Data);
                if (res2[0] < 0) {
                    PL2303Driver.DumpMsg("fail GetPL2303VendorCommand;");
                    return res2[0];
                }
                PL2303Driver.DumpMsg("Exit GP7_SET_VALUE-- val: 0x" + val);
                break;
            }
            default: {
                PL2303Driver.DumpMsg("No GPIO number");
                return -1;
            }
        }
        PL2303Driver.DumpMsg("Exit PL2303HXD_Set_GPIO_Value ");
        return 0;
    }

    public int[] PL2303HXD_Get_GPIO_Value(int GPIO_Num) {
        int[] res2 = new int[2];
        PL2303Driver.DumpMsg("Enter PL2303HXD_Set_GPIO_Value ");
        if (this.mDeviceConnection == null) {
            PL2303Driver.DumpMsg("Connection closed");
            res2[0] = -1;
            return res2;
        }
        switch (GPIO_Num) {
            case 0: {
                res2 = this.GetPL2303VendorCommand(129);
                if (res2[0] < 0) {
                    PL2303Driver.DumpMsg("fail GetPL2303VendorCommand;");
                    return res2;
                }
                PL2303Driver.DumpMsg("DCR 1 buffer: 0x" + this.IntToHex2(res2[1]));
                res2[1] = (res2[1] & 0x40) == 64 ? 1 : 0;
                PL2303Driver.DumpMsg("Exit GP0_GET_VALUE-- val: 0x" + res2[1]);
                break;
            }
            case 1: {
                res2 = this.GetPL2303VendorCommand(129);
                if (res2[0] < 0) {
                    PL2303Driver.DumpMsg("fail GetPL2303VendorCommand;");
                    return res2;
                }
                PL2303Driver.DumpMsg("DCR 1 buffer: 0x" + this.IntToHex2(res2[1]));
                res2[1] = (res2[1] & 0x80) == 128 ? 1 : 0;
                PL2303Driver.DumpMsg("Exit GP1_GET_VALUE-- val: 0x" + res2[1]);
                break;
            }
            case 2: {
                res2 = this.GetPL2303VendorCommand(141);
                if (res2[0] < 0) {
                    PL2303Driver.DumpMsg("fail GetPL2303VendorCommand;");
                    return res2;
                }
                PL2303Driver.DumpMsg("GPIO23 data: 0x" + this.IntToHex2(res2[1]));
                res2[1] = (res2[1] & 1) == 1 ? 1 : 0;
                PL2303Driver.DumpMsg("Exit GP2_GET_VALUE-- val: 0x" + res2[1]);
                break;
            }
            case 3: {
                res2 = this.GetPL2303VendorCommand(141);
                if (res2[0] < 0) {
                    PL2303Driver.DumpMsg("fail GetPL2303VendorCommand;");
                    return res2;
                }
                PL2303Driver.DumpMsg("GPIO23 data: 0x" + this.IntToHex2(res2[1]));
                res2[1] = (res2[1] & 2) == 2 ? 1 : 0;
                PL2303Driver.DumpMsg("Exit GP3_GET_VALUE-- val: 0x" + res2[1]);
                break;
            }
            case 4: {
                res2 = this.GetPL2303VendorCommand(135);
                if (res2[0] < 0) {
                    PL2303Driver.DumpMsg("fail GetPL2303VendorCommand;");
                    return res2;
                }
                PL2303Driver.DumpMsg("GPIO4567 data: 0x" + this.IntToHex2(res2[1]));
                res2[1] = (res2[1] & 1) == 1 ? 1 : 0;
                PL2303Driver.DumpMsg("Exit GP4_GET_VALUE-- val: 0x" + res2[1]);
                break;
            }
            case 5: {
                res2 = this.GetPL2303VendorCommand(135);
                if (res2[0] < 0) {
                    PL2303Driver.DumpMsg("fail GetPL2303VendorCommand;");
                    return res2;
                }
                PL2303Driver.DumpMsg("GPIO4567 data: 0x" + this.IntToHex2(res2[1]));
                res2[1] = (res2[1] & 2) == 2 ? 1 : 0;
                PL2303Driver.DumpMsg("Exit GP5_GET_VALUE-- val: 0x" + res2[1]);
                break;
            }
            case 6: {
                res2 = this.GetPL2303VendorCommand(135);
                if (res2[0] < 0) {
                    PL2303Driver.DumpMsg("fail GetPL2303VendorCommand;");
                    return res2;
                }
                PL2303Driver.DumpMsg("GPIO4567 data: 0x" + this.IntToHex2(res2[1]));
                res2[1] = (res2[1] & 4) == 4 ? 1 : 0;
                PL2303Driver.DumpMsg("Exit GP6_GET_VALUE-- val: 0x" + res2[1]);
                break;
            }
            case 7: {
                res2 = this.GetPL2303VendorCommand(135);
                if (res2[0] < 0) {
                    PL2303Driver.DumpMsg("fail GetPL2303VendorCommand;");
                    return res2;
                }
                PL2303Driver.DumpMsg("GPIO4567 data: 0x" + this.IntToHex2(res2[1]));
                res2[1] = (res2[1] & 8) == 8 ? 1 : 0;
                PL2303Driver.DumpMsg("Exit GP7_GET_VALUE-- val: 0x" + res2[1]);
                break;
            }
            default: {
                PL2303Driver.DumpMsg("No GPIO number");
                res2[0] = -1;
                return res2;
            }
        }
        PL2303Driver.DumpMsg("Exit PL2303HXD_Set_GPIO_Value ");
        return res2;
    }

    private int SetPL2303VendorCommand(int value, int index) {
        int res = 0;
        if (bDebugMesg_VendorCommand) {
            PL2303Driver.DumpMsg("Enter SetPL2303VendorCommand");
        }
        if (this.mDeviceConnection == null) {
            if (bDebugMesg_VendorCommand) {
                PL2303Driver.DumpMsg("Connection closed");
            }
            return -1;
        }
        if (bDebugMesg_VendorCommand) {
            PL2303Driver.DumpMsg("value-index: 0x" + this.IntToHex2(value) + "-0x" + this.IntToHex2(index));
        }
        if ((res = this.mDeviceConnection.controlTransfer(64, 1, value, index, null, 0, this.WrCTRLTransferTimeOut)) < 0) {
            if (bDebugMesg_VendorCommand) {
                PL2303Driver.DumpMsg("Failed : SetPL2303VendorCommand");
            }
            return res;
        }
        if (bDebugMesg_VendorCommand) {
            PL2303Driver.DumpMsg("Exit SetPL2303VendorCommand");
        }
        return res;
    }

    private int[] GetPL2303VendorCommand(int value) {
        int[] res = new int[2];
        byte[] buffer = new byte[1];
        res[0] = 0;
        if (bDebugMesg_VendorCommand) {
            PL2303Driver.DumpMsg("Enter GetPL2303VendorCommand");
        }
        if (bDebugMesg_VendorCommand) {
            PL2303Driver.DumpMsg("value: 0x" + this.IntToHex2(value));
        }
        if (this.mDeviceConnection == null) {
            if (bDebugMesg_VendorCommand) {
                PL2303Driver.DumpMsg("Connection closed");
            }
            res[0] = -1;
            return res;
        }
        res[0] = this.mDeviceConnection.controlTransfer(192, 1, value, 0, buffer, 1, this.WrCTRLTransferTimeOut);
        if (res[0] < 0) {
            if (bDebugMesg_VendorCommand) {
                PL2303Driver.DumpMsg("Faild: GetPL2303VendorCommand");
            }
            return res;
        }
        res[1] = buffer[0];
        if (bDebugMesg_VendorCommand) {
            PL2303Driver.DumpMsg("Exit GetPL2303VendorCommand, Data: 0x" + this.IntToHex2(res[1]));
        }
        return res;
    }

    private int[] GetPL2303_EEPROMData(int address) {
        int[] res = new int[2];
        res[0] = 0;
        if (bDebugMesg_EEPROMCommand) {
            PL2303Driver.DumpMsg("Enter GetPL2303_EEPROMData");
        }
        if ((res = this.GetPL2303VendorCommand(132))[0] < 0) {
            if (bDebugMesg_EEPROMCommand) {
                PL2303Driver.DumpMsg("fail GetPL2303_EEPROMData;");
            }
            return res;
        }
        if (bDebugMesg_EEPROMCommand) {
            PL2303Driver.DumpMsg("1_ data: 0x" + this.IntToHex2(res[1]));
        }
        res[0] = this.SetPL2303VendorCommand(4, address);
        if (res[0] < 0) {
            if (bDebugMesg_EEPROMCommand) {
                PL2303Driver.DumpMsg("fail GetPL2303_EEPROMData;");
            }
            return res;
        }
        res = this.GetPL2303VendorCommand(132);
        if (res[0] < 0) {
            if (bDebugMesg_EEPROMCommand) {
                PL2303Driver.DumpMsg("fail GetPL2303_EEPROMData;");
            }
            return res;
        }
        if (bDebugMesg_EEPROMCommand) {
            PL2303Driver.DumpMsg("2_ data: 0x" + this.IntToHex2(res[1]));
        }
        if ((res = this.GetPL2303VendorCommand(131))[0] < 0) {
            if (bDebugMesg_EEPROMCommand) {
                PL2303Driver.DumpMsg("fail GetPL2303_EEPROMData;");
            }
            return res;
        }
        if (bDebugMesg_EEPROMCommand) {
            PL2303Driver.DumpMsg("3_ data: 0x" + this.IntToHex2(res[1]));
        }
        if (bDebugMesg_EEPROMCommand) {
            PL2303Driver.DumpMsg("Exit GetPL2303_EEPROMData");
        }
        return res;
    }

    private boolean PL2303_IsEEPROM067B() {
        int[] res = new int[2];
        int[] rValue = new int[2];
        if (bDebugMesg_EEPROMCommand) {
            PL2303Driver.DumpMsg("Enter GetPL2303_EEPROMData");
        }
        int i = 0;
        while (i < 2) {
            res = this.GetPL2303VendorCommand(132);
            if (res[0] < 0) {
                if (bDebugMesg_EEPROMCommand) {
                    PL2303Driver.DumpMsg("fail GetPL2303_EEPROMData;");
                }
                return this.isEEPROM;
            }
            if (bDebugMesg_EEPROMCommand) {
                PL2303Driver.DumpMsg("1_ data: 0x" + this.IntToHex2(res[1]));
            }
            res[0] = this.SetPL2303VendorCommand(4, i);
            if (res[0] < 0) {
                if (bDebugMesg_EEPROMCommand) {
                    PL2303Driver.DumpMsg("fail GetPL2303_EEPROMData;");
                }
                return this.isEEPROM;
            }
            res = this.GetPL2303VendorCommand(132);
            if (res[0] < 0) {
                if (bDebugMesg_EEPROMCommand) {
                    PL2303Driver.DumpMsg("fail GetPL2303_EEPROMData;");
                }
                return this.isEEPROM;
            }
            if (bDebugMesg_EEPROMCommand) {
                PL2303Driver.DumpMsg("2_ data: 0x" + this.IntToHex2(res[1]));
            }
            if ((res = this.GetPL2303VendorCommand(131))[0] < 0) {
                if (bDebugMesg_EEPROMCommand) {
                    PL2303Driver.DumpMsg("fail GetPL2303_EEPROMData;");
                }
                return this.isEEPROM;
            }
            if (bDebugMesg_EEPROMCommand) {
                PL2303Driver.DumpMsg("3_ data: 0x" + this.IntToHex2(res[1]));
            }
            rValue[i] = res[1];
            ++i;
        }
        if (rValue[0] == 123 && rValue[1] == 6) {
            PL2303Driver.DumpMsg("IsEEPROM067B: Yes ");
            this.isEEPROM = true;
        } else {
            PL2303Driver.DumpMsg("IsEEPROM067B: No ");
        }
        return this.isEEPROM;
    }

    private int PL2303_InitHW() {
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[2] = 68;
        int[] DCR = nArray;
        int[] res2 = new int[2];
        PL2303Driver.DumpMsg("Enter PL2303_InitHW");
        int i = 0;
        while (i <= 2) {
            res2[0] = this.SetPL2303VendorCommand(i, DCR[i]);
            if (res2[0] < 0) {
                PL2303Driver.DumpMsg("fail checkPL2303ChipType;");
                return res2[0];
            }
            ++i;
        }
        int j = 128;
        while (j <= 130) {
            res2 = this.GetPL2303VendorCommand(j);
            if (res2[0] < 0) {
                if (bDebugMesg_EEPROMCommand) {
                    PL2303Driver.DumpMsg("fail GetPL2303_EEPROMData;");
                }
                return res2[0];
            }
            PL2303Driver.DumpMsg("DCR[" + (j - 128) + "] = 0x" + this.IntToHex2(res2[1]));
            ++j;
        }
        return res2[0];
    }

    public void PL2303LibGetVersion(byte[] byVersion) {
        int iLength = 0;
        iLength = byVersion.length < strLibVerionNumber.length() ? byVersion.length : strLibVerionNumber.length();
        char[] buffer = strLibVerionNumber.toCharArray();
        int i = 0;
        while (i < iLength) {
            byVersion[i] = (byte)buffer[i];
            ++i;
        }
    }

    public boolean PL2303USBFeatureSupported() {
        boolean res = this.mContext.getPackageManager().hasSystemFeature("android.hardware.usb.host");
        PL2303Driver.DumpMsg("USB feature: " + res);
        return res;
    }

    public boolean PL2303Device_IsHasPermission() {
        PL2303Driver.DumpMsg("Permission to access usb device :" + String.valueOf(this.bHasPermission));
        return this.bHasPermission;
    }

    public boolean PL2303Device_IsSupportChip() {
        boolean IsSupportChip = false;
        if (this.mPL2303Type == 4) {
            IsSupportChip = true;
        }
        PL2303Driver.DumpMsg("PL2303 chip can support this Android: " + String.valueOf(IsSupportChip));
        return IsSupportChip;
    }

    private static void DumpMsg(Object s) {
        if (bDebugMesg) {
            Log.d((String)"PL2303HXDLib", (String)(">==< " + s.toString() + " >==<"));
        }
    }

    public boolean PL2303Device_SetCommTimeouts(int TimeoutConstant) {
        if (TimeoutConstant < 0) {
            if (bDebugMesg) {
                Log.d((String)"PL2303HXDLib", (String)"Timeout Constant of read and write: Can't set < 0 ");
            }
            return false;
        }
        this.RdTransferTimeOut = TimeoutConstant;
        this.TdTransferTimeOut = TimeoutConstant;
        if (bDebugMesg) {
            Log.d((String)"PL2303HXDLib", (String)(">==< Timeout Constant of read and write:  " + String.valueOf(this.RdTransferTimeOut) + " >==<"));
        }
        return true;
    }

    public boolean PL2303Device_GetCommTimeouts(int TimeoutConstant) {
        TimeoutConstant = this.TdTransferTimeOut;
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BaudRate {
        B0,
        B75,
        B150,
        B300,
        B600,
        B1200,
        B1800,
        B2400,
        B4800,
        B9600,
        B14400,
        B19200,
        B38400,
        B57600,
        B115200,
        B230400,
        B460800,
        B614400,
        B921600,
        B1228800,
        B2457600,
        B3000000,
        B6000000,
        B12000000;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataBits {
        D5,
        D6,
        D7,
        D8;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FlowControl {
        OFF,
        RTSCTS,
        RFRCTS,
        DTRDSR,
        XONXOFF;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Parity {
        NONE,
        ODD,
        EVEN;

    }

    class ReadDataThread
    extends Thread {
        private int iReadCnt;
        private int iQueueCount;
        private boolean ret = true;
        private boolean bStop = false;
        private AtomicInteger iDelayTimeMS = new AtomicInteger(500);

        ReadDataThread() {
        }

        public void ReadDataThead() {
            this.iQueueCount = 0;
            this.iReadCnt = 0;
            PL2303Driver.this.iReadQueueArray.clear();
        }

        public void ReadDataThead(int mTimeMS) {
            this.ReadDataThead();
            this.SetDelayTimeMS(mTimeMS);
        }

        public void SetDelayTimeMS(int mTimeMS) {
            this.iDelayTimeMS.set(mTimeMS);
        }

        public void StopReadDataThread() {
            this.bStop = true;
            while (this.isAlive()) {
            }
            PL2303Driver.this.iReadQueueArray.clear();
        }

        private void DelayTime(int dwTimeMS) {
            long CheckTime;
            if (dwTimeMS == 0) {
                return;
            }
            long StartTime = System.currentTimeMillis();
            do {
                CheckTime = System.currentTimeMillis();
                Thread.yield();
            } while (CheckTime - StartTime <= (long)dwTimeMS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                byte[] rbuf = new byte[4096];
                while (!this.bStop) {
                    this.iReadCnt = PL2303Driver.this.ReadFromHW(rbuf, rbuf.length);
                    PL2303Driver.DumpMsg("iReadCnt=" + this.iReadCnt);
                    if (this.iReadCnt > 0) {
                        Object object = ReadQueueLock;
                        synchronized (object) {
                            this.iQueueCount = PL2303Driver.this.iReadQueueArray.size();
                            if (4096 == this.iQueueCount) {
                                PL2303Driver.DumpMsg("Queue is full");
                            } else {
                                int i = 0;
                                while (i < this.iReadCnt && this.iQueueCount < 4096) {
                                    this.ret = PL2303Driver.this.iReadQueueArray.offer(Integer.valueOf(rbuf[i]));
                                    if (!this.ret) {
                                        PL2303Driver.DumpMsg("Queue is full");
                                        break;
                                    }
                                    this.iQueueCount = PL2303Driver.this.iReadQueueArray.size();
                                    ++i;
                                }
                            }
                        }
                    }
                    int time = this.iDelayTimeMS.get();
                    this.DelayTime(time);
                }
            }
            catch (Exception e) {
                PL2303Driver.DumpMsg("error: " + e.getMessage());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StopBits {
        S1,
        S2;

    }
}

